<?php

/*
|
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => ['jwt.auth']], function () {

    Route::group(['middleware' => ['jwt.verify']], function () {
        //====== Pilotage Service
        Route::get('/pilotageService', 'Api\Marine\V1\PilotageServiceController@getPilotageServiceList');
        Route::get('/pilotageServiceFormData', 'Api\Marine\V1\PilotageServiceController@getPilotageServiceFormData');
        Route::post('/additionalTug', 'Api\Marine\V1\PilotageServiceController@addAdditionalTug');
        Route::post('/pilotageService', 'Api\Marine\V1\PilotageServiceController@submitPilotageService');
        //====== Swing Mooring
        Route::get('/swingMooring', 'Api\Marine\V1\SwingMooringController@getSwingMooringList');
        Route::get('/swingMooringFormData', 'Api\Marine\V1\SwingMooringController@getSwingMooringFormData');
        Route::post('/swingMooring', 'Api\Marine\V1\SwingMooringController@submitSwingMooring');
        //====== River Dues
        Route::get('/riverDues', 'Api\Marine\V1\RiverDuesController@getRiverDuesList');
        Route::get('/riverDuesFormData', 'Api\Marine\V1\RiverDuesController@getRiverDuesFormData');
        Route::post('/riverDues', 'Api\Marine\V1\RiverDuesController@submitRiverDues');
        //====== Fuel/Oil Requisition
        Route::get('/fuelRequisition', 'Api\Marine\V1\FuelRequisitionController@getFuelRequisitionList');
        Route::get('/fuelRequisitionFormData', 'Api\Marine\V1\FuelRequisitionController@getFuelRequisitionFormData');
        Route::post('/fuelRequisition', 'Api\Marine\V1\FuelRequisitionController@addFuelRequisition');
        //====== Vessel Repair Request
        Route::get('/vesselRepairRequest', 'Api\Marine\V1\VesselRepairRequestController@getVesselRepairRequestList');
        Route::get('/vesselRepairRequestFormData', 'Api\Marine\V1\VesselRepairRequestController@getVesselRepairRequestFormData');
        Route::post('/vesselRepairRequest', 'Api\Marine\V1\VesselRepairRequestController@addVesselRepairRequest');
        //====== Craft Rostering
        Route::get('/craftRostering', 'Api\Marine\V1\CraftRosteringController@getCraftRostering');
        // Route::get('/craftRosteringFormData', 'Api\Marine\V1\CraftRosteringController@getCraftRosteringFormData');
        //-------------------------- Marine Employee Search --------------------------
        // Route::get('/marineEmployeeSearch', 'Api\Marine\V1\SwingMooringController@marineEmployeeSearch');
        //====== Water Requisition Booking Acknowledgement
        Route::get('/wrbAssign', 'Api\Marine\V1\WRBAcknowledgementController@getWRBAssignList');
        // Route::get('/wrbAcknowledgementFormData', 'Api\Marine\V1\WRBAcknowledgementController@getWRBAcknowledgementFormData');
        // Route::get('/assignBarge', 'Api\Marine\V1\WRBAcknowledgementController@getAssignBargeList');
        Route::post('/wrbAckBargeStartEnd', 'Api\Marine\V1\WRBAcknowledgementController@wrbAckBargeStartEnd');
        Route::post('/wrbAcknowledgement', 'Api\Marine\V1\WRBAcknowledgementController@submitWRBAcknowledgement');
    });

});
